/*
  Funkcija: capitalizeText()
  Apraksts:
  - Saņem teksta virkni un pārvērš katra vārda (vai vārda daļas pēc "-")
    pirmo burtu par lielo, bet pārējos – par maziem.
  - Tiek izmantots ievadlauku automātiskai formatēšanai (fname, lname).
*/
function capitalizeText(text) {
  return text
    .toLowerCase() // pārvērš visu tekstu uz mazajiem burtiem
    .split(/[\s-]+/) // sadala vārdus pēc atstarpes vai domuzīmes
    .map(word => word.charAt(0).toUpperCase() + word.slice(1)) // katra vārda pirmo burtu uz lielo
    .join(" "); // apvieno atpakaļ ar atstarpēm
}

/*
  Funkcija: setupCapitalization()
  Apraksts:
  - Pievieno notikumu klausītājus vārda un uzvārda laukiem.
  - Katru reizi, kad lietotājs raksta, teksts tiek automātiski formatēts.
*/
function setupCapitalization() {
  const fields = ["fname", "lname"];
  fields.forEach(id => {
    document.getElementById(id).addEventListener("input", (e) => {
      e.target.value = capitalizeText(e.target.value);
    });
  });
}

/*
  Funkcija: validateForm()
  Apraksts:
  - Validē visus nepieciešamos ievadlaukus pirms nosūtīšanas.
  - Pārbauda tukšus laukus, garumu, datuma robežas.
  - Izceļ kļūdainos laukus ar krāsu un parāda paziņojumu.
*/
function validateForm() {
  // Noņem iepriekšējās kļūdu krāsas
  const inputs = ["fname", "lname", "cars", "date"];
  inputs.forEach(id => document.getElementById(id).classList.remove("error"));

  // Atlasa ievadlaukus
  const fname = document.getElementById("fname");
  const lname = document.getElementById("lname");
  const cars = document.getElementById("cars");
  const date = document.getElementById("date");

  let valid = true;
  let message = "";

  // --- Obligātie lauki ---
  if (fname.value.trim() === "") { message += "Ievadiet vārdu.\n"; fname.classList.add("error"); valid = false; }
  if (lname.value.trim() === "") { message += "Ievadiet uzvārdu.\n"; lname.classList.add("error"); valid = false; }
  if (cars.value === "") { message += "Izvēlieties automašīnu.\n"; cars.classList.add("error"); valid = false; }

  // --- Garums > 5 simboliem ---
  if (fname.value.trim().length <= 5) { message += "Vārdam jābūt garākam par 5 simboliem.\n"; fname.classList.add("error"); valid = false; }
  if (lname.value.trim().length <= 5) { message += "Uzvārdam jābūt garākam par 5 simboliem.\n"; lname.classList.add("error"); valid = false; }

  // --- Datuma pārbaude ---
  const today = new Date(); // šodienas datums
  const selectedDate = new Date(date.value); // izvēlētais datums
  const minDate = new Date(today);
  minDate.setFullYear(today.getFullYear() - 20); // šodiena - 20 gadi

  // pārbauda datuma korektumu
  if (isNaN(selectedDate.getTime())) {
    message += "Ievadiet derīgu datumu.\n";
    date.classList.add("error");
    valid = false;
  } else if (selectedDate > today) {
    message += "Datums nevar būt lielāks par šodienu.\n";
    date.classList.add("error");
    valid = false;
  } else if (selectedDate < minDate) {
    message += "Datums nevar būt mazāks par šodienu mīnus 20 gadi.\n";
    date.classList.add("error");
    valid = false;
  }

  // Ja ir kļūdas — izvada paziņojumu
  if (!valid) {
    alert("Lūdzu, izlabojiet kļūdas:\n\n" + message);
  }

  return valid; // ja false — neļauj sūtīt formu
}

/*
  Funkcija: submitFormJS()
  Apraksts:
  - Izsauc validateForm().
  - Ja dati ir korekti, nosūta formu uz save.php, izmantojot fetch().
  - Paziņojums par rezultātu tiek parādīts tajā pašā lapā (#result).
*/
function submitFormJS() {
  if (!validateForm()) return; // ja validācija neizdodas — apstājas

  const form = document.getElementById("dataForm");
  const formData = new FormData(form); // apstrādā formu nosūtīšanai

  // --- Nosūtīšana ar JavaScript (bez lapas pārlādes) ---
  fetch("./save-20251017115925.php", {
    method: "POST",
    body: formData
  })
  .then(res => res.text()) // sagaida atbildi kā tekstu
  .then(data => {
    // --- Rezultāta izvade tajā pašā lapā ---
    document.getElementById("result").innerHTML = `<div class='success'>${data}</div>`;
  })
  .catch(err => {
    // Ja notiek kļūda servera pusē
    document.getElementById("result").innerHTML = `<div class='error'>Kļūda saglabājot datus: ${err}</div>`;
  });
}

// --- Aktivizē teksta automātisko formatēšanu pēc lapas ielādes ---
window.addEventListener("DOMContentLoaded", setupCapitalization);
